/*
 * Decompiled with CFR 0.152.
 */
package no.jckf.dhsupport.core.world;

import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;
import no.jckf.dhsupport.core.configuration.Configurable;

public interface WorldInterface
extends Configurable {
    public WorldInterface newInstance();

    public UUID getId();

    public String getName();

    public String getKey();

    public double getCoordinateScale();

    @Nullable
    public Integer getWorldBorderX();

    @Nullable
    public Integer getWorldBorderZ();

    @Nullable
    public Integer getWorldBorderRadius();

    public boolean chunkExists(int var1, int var2);

    public boolean isChunkLoaded(int var1, int var2);

    public boolean loadChunk(int var1, int var2);

    public boolean loadOrGenerateChunk(int var1, int var2);

    public CompletableFuture<Boolean> loadChunkAsync(int var1, int var2);

    public CompletableFuture<Boolean> loadOrGenerateChunkAsync(int var1, int var2);

    public boolean unloadChunk(int var1, int var2);

    public boolean unloadChunkAsync(int var1, int var2);

    public boolean discardChunk(int var1, int var2);

    public int getMinY();

    public int getMaxY();

    public int getSeaLevel();

    public int getHighestYAt(int var1, int var2);

    public String getBiomeAt(int var1, int var2);

    public String getMaterialAt(int var1, int var2, int var3);

    public String getBlockStateAsStringAt(int var1, int var2, int var3);

    public Map<String, String> getBlockPropertiesAt(int var1, int var2, int var3);

    public byte getBlockLightAt(int var1, int var2, int var3);

    public byte getSkyLightAt(int var1, int var2, int var3);

    public boolean isBeacon(int var1, int var2, int var3);
}

