/*
 * Decompiled with CFR 0.152.
 */
package no.jckf.dhsupport.core.dataobject;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.List;
import no.jckf.dhsupport.core.bytestream.Encoder;
import no.jckf.dhsupport.core.dataobject.Beacon;
import no.jckf.dhsupport.core.dataobject.DataObject;
import no.jckf.dhsupport.core.dataobject.DataPoint;
import no.jckf.dhsupport.core.dataobject.IdMapping;
import no.jckf.dhsupport.core.dataobject.SectionPosition;
import no.jckf.dhsupport.core.enums.CompressionType;
import no.jckf.dhsupport.core.enums.GenerationStep;
import no.jckf.dhsupport.core.world.WorldInterface;
import org.tukaani.xz.FilterOptions;
import org.tukaani.xz.LZMA2Options;
import org.tukaani.xz.XZOutputStream;

public class Lod
extends DataObject {
    public static int dataFormatVersion = 1;
    public static CompressionType compressionType = CompressionType.LZMA2;
    public static int width = 64;
    protected WorldInterface worldInterface;
    protected SectionPosition position;
    protected List<IdMapping> idMappings;
    protected List<List<DataPoint>> columns;
    protected List<Beacon> beacons;

    public Lod(WorldInterface worldInterface, SectionPosition position, List<IdMapping> idMappings, List<List<DataPoint>> columns, List<Beacon> beacons) {
        this.worldInterface = worldInterface;
        this.position = position;
        this.idMappings = idMappings;
        this.columns = columns;
        this.beacons = beacons;
    }

    protected void encodeData(Encoder encoder) {
        Encoder toCompress = new Encoder();
        for (List<DataPoint> column : this.columns) {
            toCompress.writeShort(column.size());
            for (DataPoint dataPoint : column) {
                dataPoint.encode(toCompress);
            }
        }
        byte[] compressed = this.compress(toCompress.toByteArray());
        encoder.writeInt(compressed.length);
        encoder.write(compressed);
    }

    protected void encodeColumnGenerationStep(Encoder encoder) {
        byte[] bytesToCompress = new byte[width * width];
        Arrays.fill(bytesToCompress, (byte)GenerationStep.LIGHT.value);
        byte[] compressed = this.compress(bytesToCompress);
        encoder.writeInt(compressed.length);
        encoder.write(compressed);
    }

    protected void encodeWorldCompressionType(Encoder encoder) {
        byte[] bytesToCompress = new byte[width * width];
        byte[] compressed = this.compress(bytesToCompress);
        encoder.writeInt(compressed.length);
        encoder.write(compressed);
    }

    protected void encodeMappings(Encoder encoder) {
        Encoder toCompress = new Encoder();
        toCompress.writeInt(this.idMappings.size());
        for (IdMapping mapping : this.idMappings) {
            mapping.encode(toCompress);
        }
        byte[] compressed = this.compress(toCompress.toByteArray());
        encoder.writeInt(compressed.length);
        encoder.write(compressed);
    }

    @Override
    public void encode(Encoder encoder) {
        this.position.encode(encoder);
        long now = System.currentTimeMillis();
        encoder.writeInt(0);
        this.encodeData(encoder);
        this.encodeColumnGenerationStep(encoder);
        this.encodeWorldCompressionType(encoder);
        this.encodeMappings(encoder);
        encoder.writeByte(dataFormatVersion);
        encoder.writeByte(Lod.compressionType.value);
        encoder.writeBoolean(true);
        encoder.writeBoolean(false);
        encoder.writeLong(now);
        encoder.writeLong(now);
    }

    protected byte[] compress(byte[] uncompressedData) {
        ByteArrayOutputStream compressedStream = new ByteArrayOutputStream();
        try {
            XZOutputStream compressorStream = new XZOutputStream((OutputStream)compressedStream, (FilterOptions)new LZMA2Options(3), 4);
            compressorStream.write(uncompressedData);
            ((OutputStream)compressorStream).flush();
        }
        catch (Exception exception) {
            System.out.println(exception.getClass().getSimpleName() + " - " + exception.getMessage());
        }
        return compressedStream.toByteArray();
    }

    public List<Beacon> getBeacons() {
        return this.beacons;
    }
}

