/*
 * Decompiled with CFR 0.152.
 */
package no.jckf.dhsupport.core;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import org.json.JSONArray;
import org.json.JSONObject;

public class UpdateChecker {
    protected int projectId;

    public UpdateChecker(int projectId) {
        this.projectId = projectId;
    }

    protected JSONObject getLatestRelease() throws IOException {
        String line;
        URL url = URI.create("https://gitlab.com/api/v4/projects/" + this.projectId + "/releases").toURL();
        HttpURLConnection connection = (HttpURLConnection)url.openConnection();
        if (connection.getResponseCode() != 200) {
            return null;
        }
        BufferedReader in = new BufferedReader(new InputStreamReader(connection.getInputStream()));
        StringBuilder response = new StringBuilder();
        while ((line = in.readLine()) != null) {
            response.append(line);
        }
        in.close();
        JSONArray releases = new JSONArray(response.toString());
        if (releases.isEmpty()) {
            return null;
        }
        return (JSONObject)releases.get(0);
    }

    protected String getLatestVersion() {
        try {
            return this.getLatestRelease().getString("tag_name");
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public boolean isLatestVersion(String version) {
        String latestVersionString = this.getLatestVersion();
        if (latestVersionString == null) {
            return true;
        }
        String[] myVersion = version.split("[.-]");
        String[] latestVersion = latestVersionString.split("\\.");
        for (int i = 0; i < 3; ++i) {
            int latestSegment;
            int mySegment = Integer.parseInt(myVersion[i]);
            if (mySegment > (latestSegment = Integer.parseInt(latestVersion[i]))) {
                return true;
            }
            if (mySegment >= latestSegment) continue;
            return false;
        }
        return true;
    }
}

