/*
 * Decompiled with CFR 0.152.
 */
package no.jckf.dhsupport.core;

import java.time.Duration;
import java.util.ArrayList;
import java.util.concurrent.CompletableFuture;
import no.jckf.dhsupport.core.Coordinates;
import no.jckf.dhsupport.core.DhSupport;
import no.jckf.dhsupport.core.configuration.DhsConfig;
import no.jckf.dhsupport.core.database.models.LodModel;
import no.jckf.dhsupport.core.dataobject.SectionPosition;
import no.jckf.dhsupport.core.world.WorldInterface;

public class PreGenerator
implements Runnable {
    protected DhSupport dhSupport;
    protected WorldInterface world;
    protected int radius;
    protected int centerX;
    protected int centerZ;
    protected boolean force;
    protected int totalSteps;
    protected int stepsSoFar = 0;
    protected int inFlight = 0;
    protected boolean run = true;
    protected long startTime = 0L;
    protected long stopTime = 0L;

    public PreGenerator(DhSupport dhSupport, WorldInterface world, int centerX, int centerZ, int radius, boolean force) {
        this.dhSupport = dhSupport;
        this.world = world;
        this.centerX = Coordinates.blockToSection(centerX);
        this.centerZ = Coordinates.blockToSection(centerZ);
        this.radius = radius;
        this.force = force;
        this.totalSteps = (int)Math.pow((double)Coordinates.blockToChunk(this.radius) / 2.0, 2.0);
    }

    @Override
    public void run() {
        int rateLimit = this.world.getConfig().getInt(DhsConfig.FULL_DATA_REQUEST_CONCURRENCY_LIMIT);
        int currentX = this.centerX;
        int currentZ = this.centerZ;
        int[][] directions = new int[][]{{0, 1}, {1, 0}, {0, -1}, {-1, 0}};
        int dirIndex = 0;
        ArrayList<CompletableFuture> requests = new ArrayList<CompletableFuture>();
        this.startTime = System.currentTimeMillis();
        int step = 1;
        block0: while (this.stepsSoFar < this.totalSteps) {
            for (int directionChanges = 0; directionChanges < 2; ++directionChanges) {
                for (int stepsOnThisSide = 0; stepsOnThisSide < step; ++stepsOnThisSide) {
                    if (!this.run) break block0;
                    ++this.stepsSoFar;
                    if (this.stepsSoFar > this.totalSteps) break block0;
                    if (!this.force && this.dhSupport.lodRepository.lodExists(this.world.getId(), currentX += directions[dirIndex][0], currentZ += directions[dirIndex][1])) continue;
                    SectionPosition position = new SectionPosition();
                    position.setX(currentX);
                    position.setZ(currentZ);
                    position.setDetailLevel(6);
                    CompletableFuture<LodModel> request = this.dhSupport.generateLod(this.world.getId(), position);
                    request.handle((lodModel, exception) -> this.inFlight--);
                    requests.add(request);
                    ++this.inFlight;
                    while (this.inFlight >= rateLimit) {
                        CompletableFuture.anyOf(requests.toArray(new CompletableFuture[0])).join();
                        requests.removeIf(CompletableFuture::isDone);
                    }
                }
                dirIndex = (dirIndex + 1) % 4;
            }
            ++step;
        }
        this.stopTime = System.currentTimeMillis();
        this.run = false;
    }

    public int getCompletedRequests() {
        return this.stepsSoFar - this.inFlight;
    }

    public int getTargetRequests() {
        return this.totalSteps;
    }

    public float getProgress() {
        return (float)this.getCompletedRequests() / (float)this.getTargetRequests();
    }

    public Duration getElapsedTime() {
        if (this.startTime == 0L) {
            return Duration.ZERO;
        }
        return Duration.ofMillis((this.stopTime == 0L ? System.currentTimeMillis() : this.stopTime) - this.startTime);
    }

    public boolean isRunning() {
        return this.run;
    }

    public void stop() {
        this.run = false;
    }
}

