/*
 * Decompiled with CFR 0.152.
 */
package no.jckf.dhsupport.bukkit.commands;

import java.time.Duration;
import java.util.Arrays;
import java.util.UUID;
import no.jckf.dhsupport.bukkit.DhSupportBukkitPlugin;
import no.jckf.dhsupport.core.Coordinates;
import no.jckf.dhsupport.core.PreGenerator;
import no.jckf.dhsupport.core.Utils;
import no.jckf.dhsupport.core.configuration.Configuration;
import no.jckf.dhsupport.core.configuration.DhsConfig;
import no.jckf.dhsupport.core.world.WorldInterface;
import org.bukkit.ChatColor;
import org.bukkit.World;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Player;
import org.jetbrains.annotations.NotNull;

public class DhsCommand
implements CommandExecutor {
    protected DhSupportBukkitPlugin plugin;

    public DhsCommand(DhSupportBukkitPlugin plugin) {
        this.plugin = plugin;
    }

    public boolean onCommand(@NotNull CommandSender sender, @NotNull Command command, @NotNull String label, @NotNull String[] args) {
        if (args.length < 1) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "Missing sub-command.");
            return true;
        }
        switch (args[0]) {
            case "status": {
                return this.status(sender, Arrays.copyOfRange(args, 1, args.length));
            }
            case "reload": {
                return this.reload(sender);
            }
            case "worlds": {
                return this.worlds(sender);
            }
            case "pregen": {
                return this.pregen(sender, Arrays.copyOfRange(args, 1, args.length));
            }
            case "pause": {
                return this.pause(sender);
            }
            case "unpause": {
                return this.unpause(sender);
            }
            case "trim": {
                return this.trim(sender, Arrays.copyOfRange(args, 1, args.length));
            }
        }
        sender.sendMessage(String.valueOf(ChatColor.RED) + "Unknown sub-command.");
        return true;
    }

    protected boolean status(CommandSender sender, String[] args) {
        if (args.length == 0) {
            return this.statusServer(sender);
        }
        return this.statusPlayer(sender, args[0]);
    }

    protected boolean statusServer(CommandSender sender) {
        Configuration config;
        if (sender instanceof Player) {
            World world = ((Player)sender).getWorld();
            config = this.plugin.getDhSupport().getWorldInterface(world.getUID()).getConfig();
            sender.sendMessage(String.valueOf(ChatColor.BLUE) + "Distant Horizons Support status for world " + String.valueOf(ChatColor.GREEN) + world.getName() + String.valueOf(ChatColor.BLUE) + ":");
        } else {
            config = this.plugin.getDhSupport().getConfig();
            sender.sendMessage(String.valueOf(ChatColor.BLUE) + "Distant Horizons Support status for " + String.valueOf(ChatColor.GREEN) + "global context" + String.valueOf(ChatColor.BLUE) + ":");
        }
        sender.sendMessage(String.valueOf(ChatColor.BLUE) + "Distant generation is " + (config.getBool(DhsConfig.DISTANT_GENERATION_ENABLED) != false ? String.valueOf(ChatColor.GREEN) + "enabled" : String.valueOf(ChatColor.RED) + "disabled") + String.valueOf(ChatColor.BLUE) + " (" + String.valueOf(ChatColor.GREEN) + config.getInt(DhsConfig.RENDER_DISTANCE) + String.valueOf(ChatColor.BLUE) + ").");
        sender.sendMessage(String.valueOf(ChatColor.BLUE) + "Real time updates is " + (config.getBool(DhsConfig.REAL_TIME_UPDATES_ENABLED) != false ? String.valueOf(ChatColor.GREEN) + "enabled" : String.valueOf(ChatColor.RED) + "disabled") + String.valueOf(ChatColor.BLUE) + " (" + String.valueOf(ChatColor.GREEN) + config.getInt(DhsConfig.REAL_TIME_UPDATE_RADIUS) + String.valueOf(ChatColor.BLUE) + ").");
        sender.sendMessage(String.valueOf(ChatColor.BLUE) + "Builder type is " + String.valueOf(ChatColor.GREEN) + config.getString(DhsConfig.BUILDER_TYPE) + String.valueOf(ChatColor.BLUE) + ".");
        int playerCount = this.plugin.getDhSupport().getPlayerConfigurations().size();
        StringBuilder playerList = new StringBuilder();
        for (UUID playerId : this.plugin.getDhSupport().getPlayerConfigurations().keySet()) {
            playerList.append(String.valueOf(ChatColor.GREEN) + this.plugin.getServer().getPlayer(playerId).getName() + String.valueOf(ChatColor.BLUE) + ", ");
        }
        sender.sendMessage(String.valueOf(ChatColor.BLUE) + "There " + (playerCount == 1 ? "is" : "are") + " " + String.valueOf(ChatColor.GREEN) + playerCount + String.valueOf(ChatColor.BLUE) + " " + (playerCount == 1 ? "player" : "players") + " online using Distant Horizons" + (String)(playerCount == 0 ? "." : ": " + playerList.substring(0, playerList.length() - 2)));
        sender.sendMessage(String.valueOf(ChatColor.BLUE) + "Current generation speed: " + String.valueOf(ChatColor.GREEN) + String.format("%.2f", this.plugin.getDhSupport().getGenerationTracker().getPingsPerSecond() * 16.0) + " CPS");
        return true;
    }

    protected boolean statusPlayer(CommandSender sender, String playerName) {
        Player player = this.plugin.getServer().getPlayer(playerName);
        if (player == null) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "Player not found.");
            return true;
        }
        Configuration config = this.plugin.getDhSupport().getPlayerConfiguration(player.getUniqueId());
        if (config == null) {
            sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "The player " + String.valueOf(ChatColor.WHITE) + player.getName() + String.valueOf(ChatColor.YELLOW) + " is not using Distant Horizons.");
            return true;
        }
        sender.sendMessage(String.valueOf(ChatColor.BLUE) + "Distant Horizons Support status for player " + String.valueOf(ChatColor.GREEN) + player.getName() + String.valueOf(ChatColor.BLUE) + ":");
        sender.sendMessage(String.valueOf(ChatColor.BLUE) + "Distant generation is " + (config.getBool(DhsConfig.DISTANT_GENERATION_ENABLED) != false ? String.valueOf(ChatColor.GREEN) + "enabled" : String.valueOf(ChatColor.RED) + "disabled") + String.valueOf(ChatColor.BLUE) + " (" + String.valueOf(ChatColor.GREEN) + config.getInt(DhsConfig.RENDER_DISTANCE) + String.valueOf(ChatColor.BLUE) + ").");
        sender.sendMessage(String.valueOf(ChatColor.BLUE) + "Real time updates is " + (config.getBool(DhsConfig.REAL_TIME_UPDATES_ENABLED) != false ? String.valueOf(ChatColor.GREEN) + "enabled" : String.valueOf(ChatColor.RED) + "disabled") + String.valueOf(ChatColor.BLUE) + " (" + String.valueOf(ChatColor.GREEN) + config.getInt(DhsConfig.REAL_TIME_UPDATE_RADIUS) + String.valueOf(ChatColor.BLUE) + ").");
        sender.sendMessage(String.valueOf(ChatColor.BLUE) + "Server has sent " + String.valueOf(ChatColor.GREEN) + config.getInt("buffer-id", 0) + String.valueOf(ChatColor.BLUE) + " LODs to them.");
        return true;
    }

    protected boolean reload(CommandSender sender) {
        sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "Reloading config...");
        this.plugin.loadDhsConfig();
        sender.sendMessage(String.valueOf(ChatColor.GREEN) + "Reload complete.");
        return true;
    }

    protected boolean worlds(CommandSender sender) {
        sender.sendMessage(String.valueOf(ChatColor.GREEN) + "World list:");
        for (World bukkitWorld : this.plugin.getServer().getWorlds()) {
            sender.sendMessage(String.valueOf(ChatColor.YELLOW) + " - " + String.valueOf(ChatColor.GREEN) + bukkitWorld.getName() + " " + String.valueOf(ChatColor.GRAY) + "(" + String.valueOf(bukkitWorld.getUID()) + ")");
        }
        return true;
    }

    protected boolean pregen(CommandSender sender, String[] args) {
        if (args.length < 1) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "Missing action.");
            return true;
        }
        switch (args[0]) {
            case "start": {
                return this.pregenStart(sender, Arrays.copyOfRange(args, 1, args.length));
            }
            case "stop": {
                return this.pregenStop(sender, Arrays.copyOfRange(args, 1, args.length));
            }
            case "status": {
                return this.pregenStatus(sender, Arrays.copyOfRange(args, 1, args.length));
            }
        }
        sender.sendMessage(String.valueOf(ChatColor.RED) + "Unknown action.");
        return true;
    }

    protected boolean pregenStart(CommandSender sender, String[] args) {
        Integer centerZ;
        Integer centerX;
        WorldInterface world;
        if (args.length >= 1) {
            World bukkitWorld = this.plugin.getWorld(args[0]);
            if (bukkitWorld == null) {
                sender.sendMessage(String.valueOf(ChatColor.RED) + "Unknown world.");
                return true;
            }
            world = this.plugin.getDhSupport().getWorldInterface(bukkitWorld.getUID());
        } else {
            world = sender instanceof Player ? this.plugin.getDhSupport().getWorldInterface(((Player)sender).getWorld().getUID()) : null;
        }
        if (world == null) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "No world specified.");
            return true;
        }
        if (args.length >= 3) {
            centerX = Integer.parseInt(args[1]);
            centerZ = Integer.parseInt(args[2]);
        } else {
            centerX = world.getWorldBorderX();
            centerZ = world.getWorldBorderZ();
        }
        if (centerX == null || centerZ == null) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "No center coordinates specified.");
            return true;
        }
        Integer radius = args.length >= 4 ? Integer.valueOf(Coordinates.chunkToBlock(Integer.parseInt(args[3]))) : world.getWorldBorderRadius();
        if (radius == null) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "No radius specified.");
            return true;
        }
        boolean force = args.length >= 5 && args[4].equals("force");
        sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "Generating LODs for view distance of " + String.valueOf(ChatColor.GREEN) + Coordinates.blockToChunk(radius) + String.valueOf(ChatColor.YELLOW) + " chunks in world " + String.valueOf(ChatColor.GREEN) + world.getName() + String.valueOf(ChatColor.YELLOW) + " starting at center " + String.valueOf(ChatColor.GREEN) + centerX + " x " + centerZ + String.valueOf(ChatColor.YELLOW) + "...");
        if (force) {
            sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "All existing LODs in this area will be re-generated.");
        }
        this.plugin.getDhSupport().preGenerate(world, centerX, centerZ, radius, force);
        return true;
    }

    protected boolean pregenStop(CommandSender sender, String[] args) {
        WorldInterface world;
        if (args.length >= 1) {
            World bukkitWorld = this.plugin.getWorld(args[0]);
            if (bukkitWorld == null) {
                sender.sendMessage(String.valueOf(ChatColor.RED) + "Unknown world.");
                return true;
            }
            world = this.plugin.getDhSupport().getWorldInterface(bukkitWorld.getUID());
        } else {
            world = sender instanceof Player ? this.plugin.getDhSupport().getWorldInterface(((Player)sender).getWorld().getUID()) : null;
        }
        if (world == null) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "No world specified.");
            return true;
        }
        if (!this.plugin.getDhSupport().isPreGenerating(world)) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "No pre-generator running in world " + String.valueOf(ChatColor.YELLOW) + world.getName() + String.valueOf(ChatColor.RED) + ".");
            return true;
        }
        sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "Stopping pre-generation in world " + String.valueOf(ChatColor.GREEN) + world.getName() + String.valueOf(ChatColor.YELLOW) + "...");
        this.plugin.getDhSupport().stopPreGenerator(world);
        return true;
    }

    protected boolean pregenStatus(CommandSender sender, String[] args) {
        WorldInterface world;
        if (args.length >= 1) {
            World bukkitWorld = this.plugin.getWorld(args[0]);
            if (bukkitWorld == null) {
                sender.sendMessage(String.valueOf(ChatColor.RED) + "Unknown world.");
                return true;
            }
            world = this.plugin.getDhSupport().getWorldInterface(bukkitWorld.getUID());
        } else {
            world = sender instanceof Player ? this.plugin.getDhSupport().getWorldInterface(((Player)sender).getWorld().getUID()) : null;
        }
        if (world == null) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "No world specified.");
            return true;
        }
        PreGenerator generator = this.plugin.getDhSupport().getPreGenerator(world);
        if (generator == null) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "No pre-generator running in world " + String.valueOf(ChatColor.YELLOW) + world.getName() + String.valueOf(ChatColor.RED) + ".");
            return true;
        }
        Duration elapsedTime = generator.getElapsedTime();
        float momentaryLodsPerSecond = (float)this.plugin.getDhSupport().getGenerationTracker().getPingsPerSecond();
        float totalLodsPerSecond = (float)generator.getCompletedRequests() / (float)elapsedTime.toSeconds();
        sender.sendMessage(String.valueOf(ChatColor.GREEN) + "Generation progress: " + String.valueOf(ChatColor.YELLOW) + String.format("%.2f", Float.valueOf(generator.getProgress() * 100.0f)) + "%");
        sender.sendMessage(String.valueOf(ChatColor.GREEN) + "Processed LODs: " + String.valueOf(ChatColor.YELLOW) + generator.getCompletedRequests() + String.valueOf(ChatColor.GREEN) + " / " + String.valueOf(ChatColor.YELLOW) + generator.getTargetRequests() + String.valueOf(ChatColor.GREEN) + " (" + String.valueOf(ChatColor.YELLOW) + String.format("%.2f", Float.valueOf(totalLodsPerSecond * 16.0f)) + String.valueOf(ChatColor.GREEN) + " CPS)");
        sender.sendMessage(String.valueOf(ChatColor.GREEN) + "Time elapsed: " + String.valueOf(ChatColor.YELLOW) + Utils.humanReadableDuration(elapsedTime));
        if (generator.isRunning()) {
            sender.sendMessage(String.valueOf(ChatColor.GREEN) + "Time remaining: " + String.valueOf(ChatColor.YELLOW) + Utils.humanReadableDuration(Duration.ofSeconds((long)((float)(generator.getTargetRequests() - generator.getCompletedRequests()) / momentaryLodsPerSecond))));
        } else {
            sender.sendMessage(String.valueOf(ChatColor.GREEN) + "Generation is complete.");
        }
        return true;
    }

    protected boolean pause(CommandSender sender) {
        if (this.plugin.getDhSupport().isPaused()) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "Already paused.");
            return true;
        }
        if (!this.plugin.getDhSupport().pause()) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "Could not pause. Check server log for error messages.");
            return true;
        }
        sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "DHS has been paused.");
        return true;
    }

    protected boolean unpause(CommandSender sender) {
        if (!this.plugin.getDhSupport().isPaused()) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "Not paused.");
            return true;
        }
        if (!this.plugin.getDhSupport().unpause()) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "Could not unpause. Check server log for error messages.");
            return true;
        }
        sender.sendMessage(String.valueOf(ChatColor.GREEN) + "DHS has been unpaused.");
        return true;
    }

    protected boolean trim(CommandSender sender, String[] args) {
        Integer centerZ;
        Integer centerX;
        WorldInterface world;
        if (args.length >= 1) {
            World bukkitWorld = this.plugin.getWorld(args[0]);
            if (bukkitWorld == null) {
                sender.sendMessage(String.valueOf(ChatColor.RED) + "Unknown world.");
                return true;
            }
            world = this.plugin.getDhSupport().getWorldInterface(bukkitWorld.getUID());
        } else {
            world = sender instanceof Player ? this.plugin.getDhSupport().getWorldInterface(((Player)sender).getWorld().getUID()) : null;
        }
        if (world == null) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "No world specified.");
            return true;
        }
        if (args.length >= 3) {
            centerX = Integer.parseInt(args[1]);
            centerZ = Integer.parseInt(args[2]);
        } else {
            centerX = world.getWorldBorderX();
            centerZ = world.getWorldBorderZ();
        }
        if (centerX == null || centerZ == null) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "No center coordinates specified.");
            return true;
        }
        Integer radius = args.length >= 4 ? Integer.valueOf(Integer.parseInt(args[3])) : world.getWorldBorderRadius();
        if (radius == null) {
            sender.sendMessage(String.valueOf(ChatColor.RED) + "No radius specified.");
            return true;
        }
        sender.sendMessage(String.valueOf(ChatColor.YELLOW) + "Trimming LODs outside view distance of " + String.valueOf(ChatColor.GREEN) + radius + String.valueOf(ChatColor.YELLOW) + " blocks in world " + String.valueOf(ChatColor.GREEN) + world.getName() + String.valueOf(ChatColor.YELLOW) + " centered at " + String.valueOf(ChatColor.GREEN) + centerX + " x " + centerZ + String.valueOf(ChatColor.YELLOW) + "...");
        this.plugin.getDhSupport().trim(world, centerX, centerZ, radius).thenAccept(trimmedCount -> sender.sendMessage(String.valueOf(ChatColor.GREEN) + "Trimming of " + String.valueOf(ChatColor.YELLOW) + trimmedCount + String.valueOf(ChatColor.GREEN) + " LODs in " + String.valueOf(ChatColor.YELLOW) + world.getName() + String.valueOf(ChatColor.GREEN) + " completed."));
        return true;
    }
}

