/*
 * Decompiled with CFR 0.152.
 */
package no.jckf.dhsupport.bukkit;

import java.io.InputStreamReader;
import java.io.Reader;
import javax.annotation.Nullable;
import no.jckf.dhsupport.bstats.bukkit.Metrics;
import no.jckf.dhsupport.bukkit.BukkitScheduler;
import no.jckf.dhsupport.bukkit.commands.DhCommand;
import no.jckf.dhsupport.bukkit.commands.DhsCommand;
import no.jckf.dhsupport.bukkit.handler.ConfigLoader;
import no.jckf.dhsupport.bukkit.handler.PlayerHandler;
import no.jckf.dhsupport.bukkit.handler.PluginMessageProxy;
import no.jckf.dhsupport.bukkit.handler.WorldHandler;
import no.jckf.dhsupport.core.DhSupport;
import no.jckf.dhsupport.core.configuration.DhsConfig;
import org.bukkit.World;
import org.bukkit.command.CommandExecutor;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class DhSupportBukkitPlugin
extends JavaPlugin {
    protected DhSupport dhSupport;
    protected Metrics metrics;
    protected ConfigLoader configLoader;
    protected PluginMessageProxy pluginMessageProxy;
    protected BukkitScheduler scheduler;

    public void onEnable() {
        String pluginVersion = "N/A";
        String mcVersion = "N/A";
        try {
            YamlConfiguration meta = new YamlConfiguration();
            meta.load((Reader)new InputStreamReader(this.getResource("plugin.yml")));
            pluginVersion = meta.getString("version");
            mcVersion = meta.getString("mc-version");
        }
        catch (Exception meta) {
            // empty catch block
        }
        this.getLogger().info("I am DHS " + pluginVersion + " for MC " + mcVersion + ".");
        this.dhSupport = new DhSupport(pluginVersion, mcVersion);
        this.dhSupport.setLogger(this.getLogger());
        this.dhSupport.setDataDirectory(this.getDataFolder().getAbsolutePath());
        this.metrics = new Metrics((Plugin)this, 21843);
        this.loadDhsConfig();
        this.pluginMessageProxy = new PluginMessageProxy(this);
        this.pluginMessageProxy.onEnable();
        this.scheduler = new BukkitScheduler(this);
        this.dhSupport.setScheduler(this.scheduler);
        this.dhSupport.onEnable();
        int lodRefreshInterval = this.getDhSupport().getConfig().getInt(DhsConfig.LOD_REFRESH_INTERVAL) * 20;
        this.scheduler.runTimer(() -> {
            this.dhSupport.getGenerationTracker().prune();
            this.dhSupport.updateTouchedLods();
        }, lodRefreshInterval, lodRefreshInterval);
        this.getServer().getPluginManager().registerEvents((Listener)new WorldHandler(this), (Plugin)this);
        this.getServer().getPluginManager().registerEvents((Listener)new PlayerHandler(this), (Plugin)this);
        this.getCommand("dhs").setExecutor((CommandExecutor)new DhsCommand(this));
        this.getCommand("dh").setExecutor((CommandExecutor)new DhCommand(this));
        this.getLogger().info("Ready!");
    }

    public void onDisable() {
        if (this.scheduler != null) {
            this.scheduler.cancelTasks();
        }
        if (this.pluginMessageProxy != null) {
            this.pluginMessageProxy.onDisable();
            this.pluginMessageProxy = null;
        }
        if (this.configLoader != null) {
            this.configLoader.onDisable();
            this.configLoader = null;
        }
        if (this.dhSupport != null) {
            this.dhSupport.onDisable();
            this.dhSupport = null;
        }
        this.getLogger().info("Lights out!");
    }

    public void loadDhsConfig() {
        if (this.configLoader != null) {
            this.configLoader.onDisable();
        }
        this.configLoader = new ConfigLoader(this);
        this.configLoader.onEnable();
    }

    @Nullable
    public World getWorld(String name) {
        for (World world : this.getServer().getWorlds()) {
            if (!world.getName().replace(' ', '_').equals(name)) continue;
            return world;
        }
        return null;
    }

    @Nullable
    public DhSupport getDhSupport() {
        return this.dhSupport;
    }
}

