/*
 * Decompiled with CFR 0.152.
 */
package no.jckf.dhsupport.bukkit;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.logging.Logger;
import javax.annotation.Nullable;
import no.jckf.dhsupport.bukkit.DhSupportBukkitPlugin;
import no.jckf.dhsupport.core.Coordinates;
import no.jckf.dhsupport.core.configuration.Configuration;
import no.jckf.dhsupport.core.configuration.DhsConfig;
import no.jckf.dhsupport.core.configuration.WorldConfiguration;
import no.jckf.dhsupport.core.world.WorldInterface;
import org.bukkit.Bukkit;
import org.bukkit.ChunkSnapshot;
import org.bukkit.NamespacedKey;
import org.bukkit.UnsafeValues;
import org.bukkit.World;
import org.bukkit.block.Beacon;

public class BukkitWorldInterface
implements WorldInterface {
    protected static boolean BIOME_KEY_WARNING_SENT = false;
    protected static boolean ASYNC_LOAD_WARNING_SENT = false;
    protected DhSupportBukkitPlugin plugin;
    protected World world;
    protected Configuration config;
    protected WorldConfiguration worldConfig;
    protected Logger logger;
    protected Map<String, ChunkSnapshot> chunks = new HashMap<String, ChunkSnapshot>();
    protected UnsafeValues unsafeValues;
    @Nullable
    protected Method getCoordinateScale;
    @Nullable
    protected Method getBiomeKey;
    @Nullable
    protected Method getChunkAtAsync;

    public BukkitWorldInterface(DhSupportBukkitPlugin plugin, World world, Configuration config) {
        this.plugin = plugin;
        this.world = world;
        this.config = config;
        this.worldConfig = new WorldConfiguration(this, config);
    }

    public void setLogger(Logger logger) {
        this.logger = logger;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public void doUnsafeThings() {
        block7: {
            block6: {
                this.unsafeValues = Bukkit.getUnsafe();
                try {
                    this.getCoordinateScale = this.world.getClass().getMethod("getCoordinateScale", new Class[0]);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    // empty catch block
                }
                try {
                    Class<?> regionAccessor = Class.forName("org.bukkit.RegionAccessor");
                    this.getBiomeKey = this.unsafeValues.getClass().getMethod("getBiomeKey", regionAccessor, Integer.TYPE, Integer.TYPE, Integer.TYPE);
                }
                catch (ClassNotFoundException | NoSuchMethodException e) {
                    if (BIOME_KEY_WARNING_SENT) break block6;
                    this.getLogger().warning("Custom biomes are not supported on this server.");
                    BIOME_KEY_WARNING_SENT = true;
                }
            }
            try {
                this.getChunkAtAsync = this.world.getClass().getMethod("getChunkAtAsync", Integer.TYPE, Integer.TYPE, Boolean.TYPE);
            }
            catch (NoSuchMethodException exception) {
                if (ASYNC_LOAD_WARNING_SENT) break block7;
                this.getLogger().warning("Async chunk loading is not supported on this server. Performance will suffer.");
                ASYNC_LOAD_WARNING_SENT = true;
            }
        }
    }

    @Override
    public WorldInterface newInstance() {
        BukkitWorldInterface newInstance = new BukkitWorldInterface(this.plugin, this.world, this.config);
        newInstance.setLogger(this.getLogger());
        newInstance.doUnsafeThings();
        return newInstance;
    }

    protected ChunkSnapshot getChunk(int x, int z) {
        int chunkZ;
        int chunkX = Coordinates.blockToChunk(x);
        String key = chunkX + "x" + (chunkZ = Coordinates.blockToChunk(z));
        if (this.chunks.containsKey(key)) {
            return this.chunks.get(key);
        }
        ChunkSnapshot chunk = this.world.getChunkAt(chunkX, chunkZ).getChunkSnapshot(true, true, false);
        this.chunks.put(key, chunk);
        return chunk;
    }

    @Override
    public UUID getId() {
        return this.world.getUID();
    }

    @Override
    public String getName() {
        return this.world.getName();
    }

    @Override
    public String getKey() {
        return this.getName().replaceAll("[^a-zA-Z0-9_-]", "");
    }

    @Override
    public double getCoordinateScale() {
        if (this.getCoordinateScale == null) {
            boolean isNether = this.world.getEnvironment().equals((Object)World.Environment.NETHER);
            return isNether ? 8.0 : 1.0;
        }
        try {
            return (Double)this.getCoordinateScale.invoke((Object)this.world, new Object[0]);
        }
        catch (IllegalAccessException | InvocationTargetException exception) {
            throw new RuntimeException(exception);
        }
    }

    protected boolean useVanillaWorldBorder() {
        return this.worldConfig.getBool(DhsConfig.USE_VANILLA_WORLD_BORDER, true);
    }

    @Override
    public Integer getWorldBorderX() {
        if (this.useVanillaWorldBorder()) {
            return this.world.getWorldBorder().getCenter().getBlockX();
        }
        return this.worldConfig.getInt(DhsConfig.BORDER_CENTER_X);
    }

    @Override
    public Integer getWorldBorderZ() {
        if (this.useVanillaWorldBorder()) {
            return this.world.getWorldBorder().getCenter().getBlockZ();
        }
        return this.worldConfig.getInt(DhsConfig.BORDER_CENTER_Z);
    }

    @Override
    public Integer getWorldBorderRadius() {
        if (!this.useVanillaWorldBorder()) {
            return this.worldConfig.getInt(DhsConfig.BORDER_RADIUS);
        }
        int borderRadius = (int)(this.world.getWorldBorder().getSize() / 2.0);
        borderRadius = this.worldConfig.getString(DhsConfig.VANILLA_WORLD_BORDER_EXPANSION, "auto").equals("auto") ? (borderRadius += Coordinates.chunkToBlock(this.world.getViewDistance())) : (borderRadius += Coordinates.chunkToBlock(this.worldConfig.getInt(DhsConfig.VANILLA_WORLD_BORDER_EXPANSION, 0)));
        return borderRadius;
    }

    @Override
    public boolean chunkExists(int x, int z) {
        int chunkZ;
        int chunkX = Coordinates.blockToChunk(x);
        boolean alreadyLoaded = this.world.isChunkLoaded(chunkX, chunkZ = Coordinates.blockToChunk(z));
        if (alreadyLoaded) {
            return true;
        }
        int regionX = Coordinates.chunkToRegion(chunkX);
        int regionZ = Coordinates.chunkToRegion(chunkZ);
        File regionFile = new File(String.valueOf(this.world.getWorldFolder()) + "/region/r." + regionX + "." + regionZ + ".mca");
        if (!regionFile.exists()) {
            return false;
        }
        boolean exists = this.world.loadChunk(chunkX, chunkZ, false);
        if (exists) {
            this.world.unloadChunk(chunkX, chunkZ, false);
        }
        return exists;
    }

    @Override
    public boolean isChunkLoaded(int x, int z) {
        int chunkX = Coordinates.blockToChunk(x);
        int chunkZ = Coordinates.blockToChunk(z);
        return this.world.isChunkLoaded(chunkX, chunkZ);
    }

    @Override
    public boolean loadChunk(int x, int z) {
        int chunkX = Coordinates.blockToChunk(x);
        int chunkZ = Coordinates.blockToChunk(z);
        return this.world.loadChunk(chunkX, chunkZ, false);
    }

    @Override
    public boolean loadOrGenerateChunk(int x, int z) {
        int chunkX = Coordinates.blockToChunk(x);
        int chunkZ = Coordinates.blockToChunk(z);
        return this.world.loadChunk(chunkX, chunkZ, true);
    }

    @Override
    public CompletableFuture<Boolean> loadChunkAsync(int x, int z) {
        if (this.getChunkAtAsync == null) {
            return this.plugin.getDhSupport().getScheduler().runOnMainThread(() -> this.loadChunk(x, z));
        }
        int chunkX = Coordinates.blockToChunk(x);
        int chunkZ = Coordinates.blockToChunk(z);
        try {
            CompletableFuture chunkFuture = (CompletableFuture)this.getChunkAtAsync.invoke((Object)this.world, chunkX, chunkZ, false);
            return chunkFuture.thenApply(Objects::nonNull);
        }
        catch (IllegalAccessException | InvocationTargetException exception) {
            throw new RuntimeException(exception);
        }
    }

    @Override
    public CompletableFuture<Boolean> loadOrGenerateChunkAsync(int x, int z) {
        if (this.getChunkAtAsync == null) {
            return this.plugin.getDhSupport().getScheduler().runOnMainThread(() -> this.loadOrGenerateChunk(x, z));
        }
        int chunkX = Coordinates.blockToChunk(x);
        int chunkZ = Coordinates.blockToChunk(z);
        try {
            CompletableFuture chunkFuture = (CompletableFuture)this.getChunkAtAsync.invoke((Object)this.world, chunkX, chunkZ, true);
            return chunkFuture.thenApply(Objects::nonNull);
        }
        catch (IllegalAccessException | InvocationTargetException exception) {
            throw new RuntimeException(exception);
        }
    }

    @Override
    public boolean unloadChunk(int x, int z) {
        int chunkX = Coordinates.blockToChunk(x);
        int chunkZ = Coordinates.blockToChunk(z);
        return this.world.unloadChunk(chunkX, chunkZ);
    }

    @Override
    public boolean unloadChunkAsync(int x, int z) {
        int chunkX = Coordinates.blockToChunk(x);
        int chunkZ = Coordinates.blockToChunk(z);
        return this.world.unloadChunkRequest(chunkX, chunkZ);
    }

    @Override
    public boolean discardChunk(int x, int z) {
        int chunkX = Coordinates.blockToChunk(x);
        int chunkZ = Coordinates.blockToChunk(z);
        return this.world.unloadChunk(chunkX, chunkZ, false);
    }

    @Override
    public int getMinY() {
        return this.world.getMinHeight();
    }

    @Override
    public int getMaxY() {
        return this.world.getMaxHeight();
    }

    @Override
    public int getSeaLevel() {
        return Math.min(Math.max(this.getMinY(), this.world.getSeaLevel()), this.getMaxY());
    }

    @Override
    public int getHighestYAt(int x, int z) {
        return this.getChunk(x, z).getHighestBlockYAt(Coordinates.blockToChunkRelative(x), Coordinates.blockToChunkRelative(z));
    }

    @Override
    public String getBiomeAt(int x, int z) {
        NamespacedKey key = this.getChunk(x, z).getBiome(Coordinates.blockToChunkRelative(x), this.getSeaLevel(), Coordinates.blockToChunkRelative(z)).getKey();
        if (key.toString().equals("minecraft:custom") && this.getBiomeKey != null) {
            try {
                key = (NamespacedKey)this.getBiomeKey.invoke((Object)this.unsafeValues, this.world, x, this.getSeaLevel(), z);
            }
            catch (IllegalAccessException | InvocationTargetException exception) {
                throw new RuntimeException(exception);
            }
        }
        return key.toString();
    }

    @Override
    public String getMaterialAt(int x, int y, int z) {
        return this.getChunk(x, z).getBlockType(Coordinates.blockToChunkRelative(x), y, Coordinates.blockToChunkRelative(z)).getKey().toString();
    }

    @Override
    public String getBlockStateAsStringAt(int x, int y, int z) {
        return this.getChunk(x, z).getBlockData(Coordinates.blockToChunkRelative(x), y, Coordinates.blockToChunkRelative(z)).getAsString();
    }

    @Override
    public Map<String, String> getBlockPropertiesAt(int x, int y, int z) {
        String[] kvStrings;
        HashMap<String, String> properties = new HashMap<String, String>();
        String dataString = this.getBlockStateAsStringAt(x, y, z);
        int kvStart = dataString.indexOf("[");
        if (kvStart == -1) {
            return properties;
        }
        for (String kvString : kvStrings = dataString.substring(kvStart + 1, dataString.length() - 1).split(",")) {
            String[] kv = kvString.split("=", 2);
            properties.put(kv[0], kv[1]);
        }
        return properties;
    }

    @Override
    public byte getBlockLightAt(int x, int y, int z) {
        return (byte)this.getChunk(x, z).getBlockEmittedLight(Coordinates.blockToChunkRelative(x), y, Coordinates.blockToChunkRelative(z));
    }

    @Override
    public byte getSkyLightAt(int x, int y, int z) {
        return (byte)this.getChunk(x, z).getBlockSkyLight(Coordinates.blockToChunkRelative(x), y, Coordinates.blockToChunkRelative(z));
    }

    @Override
    public Configuration getConfig() {
        return this.worldConfig;
    }

    @Override
    public boolean isBeacon(int x, int y, int z) {
        if (!this.getMaterialAt(x, y, z).equals("minecraft:beacon")) {
            return false;
        }
        return this.plugin.getDhSupport().getScheduler().runOnRegionThread(this.world.getUID(), x, z, () -> ((Beacon)this.world.getBlockAt(x, y, z).getState()).getTier() > 0).join();
    }
}

